%% EJEMPLO 08: Ilustracin de algoritmos de generacin
clear; clf;

n=2e3; % Longitud del vector aleatorio a generar
%% Algoritmo 1 - Deliberadamente malo
a=57; c=1; M=256; r1=10; % Parmetros malos (r1 es la semilla)
r=zeros(1,n); r(1)=r1;
% Algoritmo
for i=2:n
    r(i)=rem(a*r(i-1)+c,M); % Genera nmeros en [0,M-1]
end
rn1=r/M; %  Ajuste de la secuencia a [0,1]
% Comprobacin visual de la secuencia
subplot(1,2,1), plot(rn1(1:n-1),rn1(2:n),'+')
title('GENERADOR DELIBERADAMENTE MALO');
xlabel('r(i)'); ylabel('r(i+1)');
% Determinacin del periodo de la secuencia
pos1=find(rn1==rn1(1)); % Posiciones en las que se repite el 1er nmero de la secuencia
T1=pos1(2)-pos1(1)
%% Algoritmo de MATLAB
rn2=rand(1,n); % Genera nmeros en [0,1]
% Comprobacin visual de la secuencia
subplot(1,2,2), plot(rn2(1:n-1),rn2(2:n),'+')
title('GENERADOR DE MATLAB rand');
xlabel('r(i)'); ylabel('r(i+1)');
% Determinacin del periodo de la secuencia
% pos2=find(rn2==rn1(2)); % Posiciones en las que se repite el 1er nmero de la secuencia
% T2=pos2(2)-pos2(1)

